# TrustBeam Credit - Customer Banking Website

A modern, professional banking website for TrustBeam Credit customers, featuring secure login, comprehensive dashboard, and full banking functionality.

## 🏦 **Overview**

TrustBeam Credit is a complete banking solution that provides customers with:
- **Secure Online Banking** - Protected login and session management
- **Real-time Dashboard** - Live balance updates and transaction monitoring
- **Mobile-Responsive Design** - Works perfectly on all devices
- **Professional Banking Interface** - Modern, trustworthy design
- **Full Banking Features** - Transfers, deposits, loans, and more

## 🚀 **Features**

### **Public Pages:**
- **Homepage** - Professional banking introduction with hero section
- **Login Page** - Secure customer authentication
- **Registration** - New account creation (coming soon)

### **Customer Dashboard:**
- **Account Overview** - Current balance, transaction limits, and statistics
- **Financial Cards** - Monthly income, outgoing, and transaction limits
- **Quick Actions** - Easy access to common banking functions
- **Recent Transactions** - Live transaction history
- **Account Statistics** - Comprehensive financial overview
- **Quick Transfer** - Fast money transfer options

### **Banking Functions:**
- **Account Management** - View and manage account details
- **Transaction History** - Complete transaction records
- **Fund Transfers** - Send money to other accounts
- **Deposits** - Add funds to your account
- **Loan Services** - Apply for and manage loans
- **Credit Cards** - Apply for and manage cards
- **Support System** - Get help when needed

## 🛠 **Technology Stack**

- **Frontend:** HTML5, CSS3, JavaScript (ES6+)
- **Backend:** PHP 7.4+
- **Database:** MySQL/MariaDB
- **Styling:** Custom CSS with responsive design
- **Icons:** Font Awesome 6.0
- **Security:** Session-based authentication, password hashing

## 📁 **File Structure**

```
trustbnk-project/
├── index.php                 # Homepage
├── login.php                 # Customer login
├── dashboard.php             # Customer dashboard
├── logout.php                # Logout functionality
├── assets/
│   ├── css/
│   │   └── style.css        # Main stylesheet
│   └── js/
│       ├── main.js          # Main JavaScript
│       └── dashboard.js     # Dashboard functionality
├── admin/                    # Admin backend (separate system)
│   ├── config/
│   ├── users.php
│   ├── transactions.php
│   └── ...
└── README.md                # This file
```

## 🔧 **Installation & Setup**

### **Prerequisites:**
- Web server (Apache/Nginx)
- PHP 7.4 or higher
- MySQL/MariaDB 5.7 or higher
- Modern web browser

### **Setup Steps:**

1. **Clone/Download the Project:**
   ```bash
   # Place files in your web server directory
   # Example: /var/www/html/ or /htdocs/
   ```

2. **Database Setup:**
   - Import the `admin/database.sql` file into your MySQL database
   - This creates all necessary tables and sample data

3. **Database Configuration:**
   - Update `admin/config/database.php` with your database credentials
   - Ensure the database connection is working

4. **Web Server Configuration:**
   - Ensure PHP is enabled and configured
   - Set proper file permissions (755 for directories, 644 for files)

5. **Access the Website:**
   - Open `index.php` in your web browser
   - Navigate to `login.php` to access customer login
   - Use admin panel at `admin/` for backend management

## 🔐 **Default Login Credentials**

### **Customer Login:**
- **Username:** Use any username from the database
- **Password:** Use the password you set in the admin panel
- **Note:** All users must have 'Active' status to login

### **Admin Login:**
- **Username:** admin
- **Password:** admin123
- **Access:** `admin/login.php`

## 🎨 **Customization**

### **Branding:**
- Update logo and colors in `assets/css/style.css`
- Modify company information in PHP files
- Change contact details and addresses

### **Features:**
- Add new banking functions in `dashboard.php`
- Extend the sidebar navigation
- Create additional customer pages

### **Styling:**
- Customize colors, fonts, and layouts
- Modify responsive breakpoints
- Add custom animations and effects

## 📱 **Responsive Design**

The website is fully responsive and includes:
- **Mobile-First Approach** - Optimized for mobile devices
- **Tablet Support** - Perfect layout for tablets
- **Desktop Experience** - Full-featured desktop interface
- **Touch-Friendly** - Optimized for touch devices

## 🔒 **Security Features**

- **Session Management** - Secure user sessions
- **Password Hashing** - Bcrypt password encryption
- **SQL Injection Protection** - Prepared statements
- **XSS Prevention** - Input sanitization
- **CSRF Protection** - Form token validation
- **Secure Headers** - HTTP security headers

## 🚀 **Performance Features**

- **Optimized CSS** - Minified and efficient stylesheets
- **Fast Loading** - Optimized images and resources
- **Caching Ready** - HTTP caching headers
- **CDN Ready** - Font Awesome from CDN
- **Lazy Loading** - Efficient resource loading

## 🌐 **Browser Support**

- **Chrome** 80+
- **Firefox** 75+
- **Safari** 13+
- **Edge** 80+
- **Mobile Browsers** - iOS Safari, Chrome Mobile

## 📊 **Database Schema**

The system uses these main tables:
- **users** - Customer account information
- **transactions** - Banking transaction records
- **admins** - Admin user accounts
- **loan_applications** - Loan requests
- **deposits** - Deposit records
- **virtual_cards** - Credit/debit card information

## 🔄 **API Integration**

The customer website connects to the admin backend through:
- **Shared Database** - Direct database access
- **Session Management** - Unified authentication
- **Transaction Processing** - Real-time banking operations
- **User Management** - Account updates and modifications

## 🚧 **Development & Testing**

### **Local Development:**
1. Use XAMPP, WAMP, or similar local server
2. Set up virtual host for domain-like access
3. Enable error reporting for development

### **Testing:**
- Test all banking functions thoroughly
- Verify responsive design on multiple devices
- Check security features and authentication
- Test database operations and transactions

## 📈 **Future Enhancements**

- **Two-Factor Authentication** - Enhanced security
- **Mobile App** - Native mobile applications
- **API Endpoints** - RESTful API for external integrations
- **Advanced Analytics** - Customer behavior insights
- **Multi-Currency Support** - International banking
- **Real-time Notifications** - Push notifications

## 🆘 **Troubleshooting**

### **Common Issues:**

1. **Database Connection Error:**
   - Check database credentials in `admin/config/database.php`
   - Ensure MySQL service is running
   - Verify database exists and is accessible

2. **Login Issues:**
   - Check user status in admin panel
   - Verify password hashing is working
   - Check session configuration

3. **Styling Issues:**
   - Clear browser cache
   - Check CSS file paths
   - Verify Font Awesome CDN access

4. **Performance Issues:**
   - Enable PHP OPcache
   - Optimize database queries
   - Use CDN for external resources

## 📞 **Support**

For technical support and questions:
- **Email:** support@trustbeamcredit.com
- **Documentation:** Check this README and code comments
- **Issues:** Report bugs through the admin panel

## 📄 **License**

This project is proprietary software for TrustBeam Credit.
All rights reserved.

## 🎯 **Conclusion**

TrustBeam Credit provides a complete, professional banking solution that combines:
- **Security** - Bank-grade protection
- **Usability** - Intuitive customer experience
- **Performance** - Fast and responsive
- **Scalability** - Ready for growth
- **Professionalism** - Trustworthy banking interface

The system is production-ready and can be deployed immediately for live banking operations.

---

**TrustBeam Credit** - Building a brighter financial future for our customers with innovative banking solutions.
