# TrustBeam Credit - Bank Admin Panel

A comprehensive banking administration system built with PHP, HTML, CSS, and JavaScript.

## 🚀 Features

### Core Functionality
- **User Management**: Create, view, and manage bank users
- **Dashboard**: Real-time statistics and overview
- **Authentication**: Secure admin login system
- **Responsive Design**: Works on all devices
- **Modern UI**: Clean and professional interface

### Banking Operations
- **Account Management**: Savings, Current, Business, Premium accounts
- **Transaction Tracking**: Monitor all banking transactions
- **Loan Applications**: Process and manage loan requests
- **Virtual Cards**: Manage virtual card services
- **IRS Refunds**: Handle tax refund processing
- **Email Services**: Integrated communication system

### Security Features
- **Session Management**: Secure admin sessions
- **Password Hashing**: Bcrypt encryption
- **SQL Injection Protection**: Prepared statements
- **XSS Prevention**: Input sanitization

## 📋 Requirements

- **Web Server**: Apache/Nginx
- **PHP**: 7.4 or higher
- **MySQL**: 5.7 or higher
- **Browser**: Modern browsers (Chrome, Firefox, Safari, Edge)

## 🛠️ Installation

### 1. Database Setup

1. **Create Database**:
   ```sql
   CREATE DATABASE trustbeam_bank;
   ```

2. **Import Schema**:
   ```bash
   mysql -u root -p trustbeam_bank < database.sql
   ```

3. **Configure Database Connection**:
   Edit `config/database.php` with your database credentials:
   ```php
   private $host = 'localhost';
   private $db_name = 'trustbeam_bank';
   private $username = 'your_username';
   private $password = 'your_password';
   ```

### 2. File Setup

1. **Upload Files**: Place all files in your web server directory
2. **Set Permissions**: Ensure proper file permissions (755 for directories, 644 for files)
3. **Create Upload Directory**: 
   ```bash
   mkdir uploads/profiles
   chmod 755 uploads/profiles
   ```

### 3. Web Server Configuration

#### Apache (.htaccess)
```apache
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule ^(.*)$ index.php [QSA,L]

# Security headers
Header always set X-Content-Type-Options nosniff
Header always set X-Frame-Options DENY
Header always set X-XSS-Protection "1; mode=block"
```

#### Nginx
```nginx
location / {
    try_files $uri $uri/ /index.php?$query_string;
}

# Security headers
add_header X-Content-Type-Options nosniff;
add_header X-Frame-Options DENY;
add_header X-XSS-Protection "1; mode=block";
```

## 🔐 Default Login

- **Username**: `admin`
- **Password**: `password`

**⚠️ Important**: Change these credentials immediately after first login!

## 📁 File Structure

```
admin/
├── assets/
│   ├── css/
│   │   └── style.css
│   └── js/
│       └── admin.js
├── config/
│   └── database.php
├── uploads/
│   └── profiles/
├── database.sql
├── index.php
├── login.php
├── logout.php
├── create-user.php
└── README.md
```

## 🎯 Usage Guide

### 1. Access Admin Panel
- Navigate to `your-domain.com/admin/`
- Login with default credentials
- Change password immediately

### 2. Create New Users
- Go to "Create New User" in sidebar
- Fill in user information
- System auto-generates account numbers and codes
- Upload profile photos (optional)

### 3. Manage Users
- View all users in "Manage Users"
- Filter by status (Active, Pending, Inactive)
- Edit user information
- Update account status

### 4. Monitor Transactions
- Track all banking transactions
- View transaction history
- Monitor pending transactions

### 5. Process Loans
- Review loan applications
- Approve/reject requests
- Set interest rates and terms

## 🔧 Customization

### Styling
- Edit `assets/css/style.css` for custom colors and layouts
- Modify CSS variables for consistent theming

### Functionality
- Extend `assets/js/admin.js` for additional features
- Add new PHP files for additional admin functions

### Database
- Modify `database.sql` for additional tables
- Update database connection in `config/database.php`

## 🚨 Security Considerations

1. **Change Default Credentials**: Immediately after installation
2. **HTTPS**: Use SSL/TLS encryption in production
3. **File Permissions**: Restrict access to sensitive files
4. **Regular Updates**: Keep PHP and MySQL updated
5. **Backup**: Regular database and file backups
6. **Firewall**: Implement proper server security

## 📱 Responsive Design

The admin panel is fully responsive and works on:
- **Desktop**: Full sidebar navigation
- **Tablet**: Collapsible sidebar
- **Mobile**: Hamburger menu with overlay

## 🎨 UI Components

### Color Scheme
- **Primary**: #667eea (Blue)
- **Secondary**: #764ba2 (Purple)
- **Success**: #28a745 (Green)
- **Warning**: #ffc107 (Yellow)
- **Error**: #dc3545 (Red)

### Icons
- **Font Awesome 6.0**: Modern icon library
- **Consistent**: Unified icon style throughout

## 🔄 Future Enhancements

- [ ] **API Integration**: RESTful API endpoints
- [ ] **Advanced Reporting**: Charts and analytics
- [ ] **Multi-language**: Internationalization support
- [ ] **Audit Logs**: Comprehensive activity tracking
- [ ] **Two-Factor Authentication**: Enhanced security
- [ ] **Real-time Notifications**: WebSocket integration

## 🐛 Troubleshooting

### Common Issues

1. **Database Connection Error**:
   - Check database credentials in `config/database.php`
   - Ensure MySQL service is running
   - Verify database exists

2. **Upload Errors**:
   - Check directory permissions
   - Verify PHP upload settings
   - Ensure sufficient disk space

3. **Session Issues**:
   - Check PHP session configuration
   - Verify cookie settings
   - Clear browser cache

4. **Styling Issues**:
   - Check CSS file paths
   - Verify Font Awesome CDN
   - Clear browser cache

### Debug Mode

Enable error reporting in PHP:
```php
error_reporting(E_ALL);
ini_set('display_errors', 1);
```

## 📞 Support

For technical support or feature requests:
- **Documentation**: Check this README first
- **Issues**: Report bugs with detailed information
- **Contributions**: Pull requests welcome

## 📄 License

This project is licensed under the MIT License - see the LICENSE file for details.

## 🙏 Acknowledgments

- **Font Awesome**: Icon library
- **PHP Community**: Best practices and security
- **Modern CSS**: Grid and Flexbox layouts

---

**Built with ❤️ for TrustBeam Credit Banking System**
