-- Add Currency Support to Users Table
-- This script adds a currency field to support multiple currencies (USD, EUR, GBP, SEK, etc.)

USE nexus;

-- Add currency column to users table
ALTER TABLE `users` 
ADD COLUMN `currency` ENUM('USD', 'EUR', 'GBP', 'SEK', 'CAD', 'AUD', 'JPY', 'CHF', 'NOK', 'DKK', 'PLN', 'CZK', 'HUF', 'BGN', 'RON', 'HRK', 'RSD', 'MKD', 'ALL', 'ISK', 'ARS', 'HKD', 'CNY', 'BRL', 'MXN', 'MYR', 'VES') DEFAULT 'USD' AFTER `balance`;

-- Update existing users to have USD as default currency (optional)
-- UPDATE `users` SET `currency` = 'USD' WHERE `currency` IS NULL;

-- Show the updated table structure
DESCRIBE `users`;
