<?php
namespace TrustBnk\Admin\Lib;

class EmailTemplates {
    public static function wrap(string $siteName, ?string $logoUrl, string $title, string $bodyHtml): string {
        $brand = htmlspecialchars($siteName ?: 'TrustBank', ENT_QUOTES, 'UTF-8');
        $logo = $logoUrl ? htmlspecialchars($logoUrl, ENT_QUOTES, 'UTF-8') : '';
        $year = date('Y');
        $logoImg = $logo ? '<img src="' . $logo . '" alt="' . $brand . '" height="28" style="vertical-align:middle;" />' : '';

        $html = "<div style=\"margin:0;padding:0;background:#f5f7fb;width:100%;\">" .
                "<table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"background:#f5f7fb;padding:24px 0;\">" .
                "<tr><td align=\"center\">" .
                "<table role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"width:600px;max-width:90%;background:#ffffff;border-radius:12px;overflow:hidden;box-shadow:0 8px 28px rgba(25,118,210,0.15);\">" .
                "<tr><td style=\"padding:0;background:linear-gradient(135deg,#d32f2f 0%,#1976d2 100%);\">" .
                "<div style=\"padding:28px 32px;\">" .
                "<div style=\"font:700 20px/1.2 system-ui,-apple-system,Segoe UI,Roboto,Ubuntu; color:#ffffff;display:flex;align-items:center;gap:10px;\">" . $logoImg . "<span style=\"margin-left:10px;vertical-align:middle;\">" . $brand . "</span></div>" .
                "<div style=\"margin-top:8px;font:600 18px/1.4 system-ui,-apple-system,Segoe UI,Roboto,Ubuntu;color:#ffffff;\">" . htmlspecialchars($title, ENT_QUOTES, 'UTF-8') . "</div>" .
                "</div></td></tr>" .
                "<tr><td style=\"padding:28px 32px;font:400 15px/1.7 system-ui,-apple-system,Segoe UI,Roboto,Ubuntu;color:#1f2937;\">" .
                $bodyHtml .
                "</td></tr>" .
                "<tr><td style=\"padding:16px 32px;background:#f9fafb;border-top:1px solid #e5e7eb;\">" .
                "<div style=\"font:400 13px/1.6 system-ui,-apple-system,Segoe UI,Roboto,Ubuntu;color:#6b7280;text-align:center;\">" .
                "&copy; " . $year . " " . $brand . ". All rights reserved." .
                "</div></td></tr>" .
                "</table></td></tr></table></div>";

        return $html;
    }

    public static function welcome(array $general, array $user): array {
        $site = $general['site_name'] ?? 'TrustBank';
        $logo = !empty($general['logo_path']) ? (string)$general['logo_path'] : null;
        $title = 'Welcome to ' . $site;
        $fullName = trim(($user['firstname'] ?? '') . ' ' . ($user['lastname'] ?? ''));
        $account = htmlspecialchars($user['account_number'] ?? '', ENT_QUOTES, 'UTF-8');
        $type = htmlspecialchars($user['account_type'] ?? '', ENT_QUOTES, 'UTF-8');
        $balance = number_format((float)($user['balance'] ?? 0), 2);
        $currencySymbol = $user['currency'] ?? '$';
        $createdAt = isset($user['created_at']) ? date('Y-m-d H:i', strtotime($user['created_at'])) : date('Y-m-d H:i');
        $body = '<p>Hi ' . htmlspecialchars($fullName, ENT_QUOTES, 'UTF-8') . ',</p>' .
            '<p>Your account has been created successfully. Below are your key details:</p>' .
            '<ul style="padding-left:18px;margin:0 0 16px 0;">' .
            '<li><strong>Account Number:</strong> ' . $account . '</li>' .
            '<li><strong>Account Type:</strong> ' . $type . '</li>' .
            '<li><strong>Opening Balance:</strong> ' . $currencySymbol . $balance . '</li>' .
            '<li><strong>Date of Registration:</strong> ' . htmlspecialchars($createdAt, ENT_QUOTES, 'UTF-8') . '</li>' .
            '</ul>' .
            '<p>You can sign in anytime to manage your banking.</p>';
        $html = self::wrap($site, $logo, $title, $body);
        return [$title, $html];
    }

    public static function transactionAlert(array $general, array $user, string $direction, float $amount, string $reference, string $description, string $dateTime, float $availableBalance, string $currency = '$'): array {
        $site = $general['site_name'] ?? 'TrustBank';
        $logo = !empty($general['logo_path']) ? (string)$general['logo_path'] : null;
        $title = ($direction === 'credit' ? 'Credit' : 'Debit') . ' Alert';
        $fullName = trim(($user['firstname'] ?? '') . ' ' . ($user['lastname'] ?? ''));
        $currencySymbol = $currency ?: '$';
        $body = '<p>Hi ' . htmlspecialchars($fullName, ENT_QUOTES, 'UTF-8') . ',</p>' .
            '<p>You have a <strong>' . ($direction === 'credit' ? 'credit' : 'debit') . '</strong> transaction on your account.</p>' .
            '<table cellpadding="0" cellspacing="0" style="width:100%;border-collapse:collapse;margin:12px 0;">' .
            '<tr><td style="padding:8px 0;color:#6b7280;">Amount</td><td style="padding:8px 0;text-align:right;color:#111827;"><strong>' . $currencySymbol . number_format($amount, 2) . '</strong></td></tr>' .
            '<tr><td style="padding:8px 0;color:#6b7280;">Type</td><td style="padding:8px 0;text-align:right;color:#111827;">' . ($direction === 'credit' ? 'Credit' : 'Debit') . '</td></tr>' .
            '<tr><td style="padding:8px 0;color:#6b7280;">Reference</td><td style="padding:8px 0;text-align:right;color:#111827;">' . htmlspecialchars($reference, ENT_QUOTES, 'UTF-8') . '</td></tr>' .
            '<tr><td style="padding:8px 0;color:#6b7280;">Description</td><td style="padding:8px 0;text-align:right;color:#111827;">' . htmlspecialchars($description ?? '', ENT_QUOTES, 'UTF-8') . '</td></tr>' .
            '<tr><td style="padding:8px 0;color:#6b7280;">Date</td><td style="padding:8px 0;text-align:right;color:#111827;">' . htmlspecialchars($dateTime, ENT_QUOTES, 'UTF-8') . '</td></tr>' .
            '</table>' .
            '<p>Available balance: <strong>' . $currencySymbol . number_format($availableBalance, 2) . '</strong></p>';
        $html = self::wrap($site, $logo, $title, $body);
        $subject = $title . ' - ' . $reference;
        return [$subject, $html];
    }
}
?>


