<?php
// Start session
session_start();

// Include database connection
require_once 'admin/config/database.php';

// Get general settings and hero images from database
try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Get general settings
    $settingsQuery = "SELECT * FROM general_settings WHERE id = 1";
    $settingsResult = $db->prepare($settingsQuery);
    $settingsResult->execute();
    $settings = $settingsResult->fetch(PDO::FETCH_ASSOC);
    
    // Get hero images
    $heroQuery = "SELECT * FROM hero_images ORDER BY created_at DESC";
    $heroResult = $db->prepare($heroQuery);
    $heroResult->execute();
    $heroImages = $heroResult->fetchAll(PDO::FETCH_ASSOC);
    
    // Close connection
    $database->closeConnection();
    
} catch (Exception $e) {
    // Fallback data if database fails
    $settings = [
        'site_name' => 'TrustBeam Credit',
        'logo_path' => null,
        'mobile_number' => '+1 (555) 123-4567',
        'address' => '123 Banking Street, Financial District'
    ];
    $heroImages = [
        [
            'image_path' => 'admin/uploads/site/hero_1757870486_20989c.jpg',
            'title' => 'Bank with the Happiest Customers'
        ]
    ];
}

// Set default values
$siteName = $settings['site_name'] ?? 'TrustBeam Credit';
$logoPath = $settings['logo_path'] ?? null;
$phoneNumber = $settings['mobile_number'] ?? '+1 (555) 123-4567';
$address = $settings['address'] ?? '123 Banking Street, Financial District';
$heroImage = !empty($heroImages) ? $heroImages[0]['image_path'] : 'admin/uploads/site/hero_1757870486_20989c.jpg';
$heroTitle = !empty($heroImages) ? $heroImages[0]['title'] : 'Bank with the Happiest Customers in the World';

// Debug: Check if image exists
$imageExists = file_exists($heroImage);
if (!$imageExists && !empty($heroImages)) {
    // Try alternative path
    $altPath = str_replace('admin/uploads/', 'uploads/', $heroImage);
    if (file_exists($altPath)) {
        $heroImage = $altPath;
    } else {
        // Use default image if none exists
        $heroImage = 'admin/uploads/site/hero_1757870486_20989c.jpg';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($siteName); ?> - Bank with the Happiest Customers</title>
    
    <!-- CSS Files -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Google Translator -->
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({
                pageLanguage: 'en',
                includedLanguages: 'en,es,fr,de,it,pt,ru,ja,ko,zh-CN,zh-TW,ar,hi',
                layout: google.translate.TranslateElement.InlineLayout.SIMPLE,
                autoDisplay: false
            }, 'google_translate_element');
        }
    </script>
    <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    
    <!-- Pre-loader Styles -->
    <style>
        /* Pre-loader Styles */
        .preloader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            z-index: 99999;
            transition: opacity 0.5s ease, visibility 0.5s ease;
        }
        
        .preloader.hidden {
            opacity: 0;
            visibility: hidden;
        }
        
        .preloader-content {
            text-align: center;
            color: white;
        }
        
        .preloader-logo {
            width: 120px;
            height: 120px;
            border: 4px solid rgba(255, 255, 255, 0.3);
            border-top: 4px solid #ff4757;
            border-radius: 50%;
            animation: eclipse 2s linear infinite;
            margin-bottom: 30px;
            position: relative;
            padding-left: 20px;
        }
        
        .preloader-logo::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            box-shadow: 0 0 20px rgba(255, 71, 87, 0.5);
        }
        
        .preloader-logo-img {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 50px;
            height: 50px;
            object-fit: contain;
            border-radius: 50%;
            z-index: 10;
        }
        
        .preloader-text {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 10px;
            animation: textPulse 2s ease-in-out infinite;
            background: linear-gradient(45deg, #ff4757, #ffa502, #ff4757);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            background-size: 200% 200%;
            animation: gradientShift 3s ease-in-out infinite;
        }
        
        .preloader-subtitle {
            font-size: 1rem;
            opacity: 0.8;
            animation: fadeInUp 1s ease 0.5s both;
        }
        
        .preloader-progress {
            width: 200px;
            height: 4px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 2px;
            margin-top: 20px;
            overflow: hidden;
        }
        
        .preloader-progress-bar {
            height: 100%;
            background: linear-gradient(90deg, #ff4757, #ffa502);
            border-radius: 2px;
            animation: progressLoad 3s ease-in-out;
        }
        
        @keyframes eclipse {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        @keyframes textPulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        
        @keyframes gradientShift {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes progressLoad {
            0% { width: 0%; }
            100% { width: 100%; }
        }
        
        /* Parallax Styles */
        .parallax-container {
            position: relative;
            overflow: hidden;
        }
        
        .parallax-bg {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 120%;
            background-attachment: fixed;
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            transition: transform 0.1s ease-out;
        }
        
        .parallax-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.4);
            z-index: 1;
        }
        
        .parallax-content {
            position: relative;
            z-index: 2;
        }
        
        /* Animated Text Styles */
        .animated-text {
            opacity: 0;
            transform: translateY(30px);
            animation: slideInUp 1s ease forwards;
        }
        
        .animated-text.delay-1 { animation-delay: 0.2s; }
        .animated-text.delay-2 { animation-delay: 0.4s; }
        .animated-text.delay-3 { animation-delay: 0.6s; }
        .animated-text.delay-4 { animation-delay: 0.8s; }
        
        @keyframes slideInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        /* Responsive Header Styles */
        .mobile-menu-toggle {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 1.5rem;
            cursor: pointer;
            padding: 10px;
        }
        
        .mobile-nav {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            width: 100%;
            background: rgba(102, 126, 234, 0.98);
            backdrop-filter: blur(10px);
            padding: 20px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
        }
        
        .mobile-nav.active {
            display: block;
            animation: slideDown 0.3s ease;
        }
        
        .mobile-nav a {
            display: block;
            color: white;
            text-decoration: none;
            padding: 12px 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }
        
        .mobile-nav a:hover {
            color: #ffa502;
            padding-left: 10px;
        }
        
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        /* Enhanced Hero Section */
        .hero-enhanced {
            min-height: 100vh;
            display: flex;
            align-items: center;
            position: relative;
            overflow: hidden;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .hero-content-enhanced {
            text-align: center;
            color: white;
            z-index: 3;
            position: relative;
        }
        
        .hero-title-enhanced {
            font-size: 3.5rem;
            font-weight: 800;
            margin-bottom: 20px;
            line-height: 1.2;
        }
        
        .hero-subtitle-enhanced {
            font-size: 1.3rem;
            margin-bottom: 40px;
            opacity: 0.9;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .hero-buttons {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
        }
        
        .btn-hero-enhanced {
            padding: 15px 30px;
            font-size: 1.1rem;
            font-weight: 600;
            border-radius: 50px;
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 10px;
        }
        
        .btn-hero-primary {
            background: linear-gradient(135deg, #ff4757, #ff6b7a);
            color: white;
            box-shadow: 0 8px 25px rgba(255, 71, 87, 0.3);
        }
        
        .btn-hero-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 35px rgba(255, 71, 87, 0.4);
        }
        
        .btn-hero-secondary {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            border: 2px solid rgba(255, 255, 255, 0.3);
            backdrop-filter: blur(10px);
        }
        
        .btn-hero-secondary:hover {
            background: rgba(255, 255, 255, 0.2);
            border-color: rgba(255, 255, 255, 0.5);
            transform: translateY(-3px);
        }
        
        /* Floating Elements */
        .floating-elements {
            position: absolute;
            width: 100%;
            height: 100%;
            overflow: hidden;
            pointer-events: none;
            z-index: 1;
        }
        
        .floating-circle {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            animation: float 6s ease-in-out infinite;
        }
        
        .floating-circle:nth-child(1) {
            width: 80px;
            height: 80px;
            top: 20%;
            left: 10%;
            animation-delay: 0s;
        }
        
        .floating-circle:nth-child(2) {
            width: 120px;
            height: 120px;
            top: 60%;
            right: 15%;
            animation-delay: 2s;
        }
        
        .floating-circle:nth-child(3) {
            width: 60px;
            height: 60px;
            bottom: 30%;
            left: 20%;
            animation-delay: 4s;
        }
        
        @keyframes float {
            0%, 100% {
                transform: translateY(0px) rotate(0deg);
            }
            50% {
                transform: translateY(-20px) rotate(180deg);
            }
        }
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            .mobile-menu-toggle {
                display: block;
            }
            
            .nav-center {
                display: none;
            }
            
            .hero-title-enhanced {
                font-size: 2.5rem;
            }
            
            .hero-subtitle-enhanced {
                font-size: 1.1rem;
            }
            
            .hero-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .btn-hero-enhanced {
                width: 100%;
                max-width: 300px;
                justify-content: center;
            }
        }
        
        @media (max-width: 480px) {
            .hero-title-enhanced {
                font-size: 2rem;
            }
            
            .hero-subtitle-enhanced {
                font-size: 1rem;
            }
            
            .preloader-text {
                font-size: 1.5rem;
            }
        }
        
        /* Google Translator Styles - Fixed Position Bottom */
        .translator-container {
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 1000;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 50px;
            padding: 10px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
        }
        
        .translator-container:hover {
            background: rgba(255, 255, 255, 1);
            box-shadow: 0 12px 35px rgba(0, 0, 0, 0.2);
            transform: scale(1.05);
        }
        
        .goog-te-gadget {
            font-family: 'Inter', sans-serif !important;
        }
        
        .goog-te-gadget-simple {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
            border: none !important;
            border-radius: 25px !important;
            padding: 12px 20px !important;
            font-size: 0.9rem !important;
            color: white !important;
            cursor: pointer !important;
            transition: all 0.3s ease !important;
            font-weight: 600 !important;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3) !important;
        }
        
        .goog-te-gadget-simple:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%) !important;
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4) !important;
            transform: translateY(-2px) !important;
        }
        
        .goog-te-gadget-simple .goog-te-menu-value span:first-child {
            color: white !important;
        }
        
        .goog-te-gadget-simple .goog-te-menu-value span:first-child:after {
            content: " 🌐" !important;
        }
        
        /* Hide the Google branding */
        .goog-te-banner-frame {
            display: none !important;
        }
        
        /* Style the dropdown */
        .goog-te-menu2 {
            background: white !important;
            border: 1px solid #ddd !important;
            border-radius: 12px !important;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2) !important;
            margin-top: 10px !important;
            overflow: hidden !important;
        }
        
        .goog-te-menu2-item {
            padding: 12px 20px !important;
            border-bottom: 1px solid #f0f0f0 !important;
            transition: all 0.3s ease !important;
        }
        
        .goog-te-menu2-item:hover {
            background: #f8f9fa !important;
            padding-left: 25px !important;
        }
        
        .goog-te-menu2-item:last-child {
            border-bottom: none !important;
        }
        
        /* Mobile responsive */
        @media (max-width: 768px) {
            .translator-container {
                bottom: 15px;
                right: 15px;
                padding: 8px;
            }
            
            .goog-te-gadget-simple {
                padding: 10px 16px !important;
                font-size: 0.8rem !important;
            }
        }
        
        @media (max-width: 480px) {
            .translator-container {
                bottom: 10px;
                right: 10px;
                padding: 6px;
            }
            
            .goog-te-gadget-simple {
                padding: 8px 12px !important;
                font-size: 0.75rem !important;
            }
        }
        
        /* Header Layout Fixes */
        .main-nav .nav-container {
            display: flex;
            align-items: center;
            justify-content: space-between;
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 15px;
            width: 100%;
            box-sizing: border-box;
        }
        
        .nav-left {
            flex: 0 0 auto;
            margin-right: 20px;
            min-width: 0;
        }
        
        .nav-center {
            flex: 1;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 20px;
            min-width: 0;
            overflow: hidden;
        }
        
        .nav-right {
            flex: 0 0 auto;
            display: flex;
            align-items: center;
            gap: 10px;
            margin-left: 20px;
            min-width: 0;
        }
        
        /* Reduce Open Account Button Size */
        .btn-primary {
            padding: 8px 14px !important;
            font-size: 0.8rem !important;
            font-weight: 400 !important;
            white-space: nowrap !important;
        }
        
        .btn-login {
            padding: 8px 16px !important;
            font-size: 0.9rem !important;
            font-weight: 500 !important;
        }
        
        /* Logo Spacing */
        .logo {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .logo-text {
            display: flex;
            flex-direction: column;
        }
        
        .logo-main {
            font-size: 1.4rem;
            font-weight: 700;
            color: #2c3e50;
            line-height: 1;
        }
        
        .logo-sub {
            font-size: 0.9rem;
            font-weight: 500;
            color: #667eea;
            line-height: 1;
        }
        
        /* Navigation Links Spacing */
        .nav-link {
            padding: 8px 10px;
            font-weight: 500;
            font-size: 0.9rem;
            transition: all 0.3s ease;
            white-space: nowrap;
        }
        
        .nav-link:hover {
            color: #667eea;
        }
        
        /* Compact logo for smaller screens */
        .logo-text .logo-main {
            font-size: 1.2rem;
        }
        
        .logo-text .logo-sub {
            font-size: 0.8rem;
        }
        
        /* Logo Image Styles */
        .logo-image {
            width: 120px;
            height: 120px;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }
        
        .logo-img {
            width: 120px;
            height: 120px;
            object-fit: contain;
            object-position: center;
        }
        
        /* Responsive breakpoints for better container fit */
        @media (max-width: 1200px) {
            .nav-center {
                gap: 15px;
            }
            
            .nav-link {
                padding: 8px 8px;
                font-size: 0.85rem;
            }
        }
        
        @media (max-width: 1024px) {
            .nav-container {
                padding: 0 10px;
            }
            
            .nav-center {
                gap: 10px;
            }
            
            .nav-link {
                padding: 6px 8px;
                font-size: 0.8rem;
            }
            
            .btn-primary, .btn-login {
                padding: 6px 12px !important;
                font-size: 0.75rem !important;
            }
        }
        
        @media (max-width: 768px) {
            .nav-center {
                display: none;
            }
            
            .nav-right .btn {
                display: none;
            }
            
            .nav-container {
                justify-content: space-between;
                padding: 0 10px;
            }
            
            .nav-left {
                margin-right: 0;
            }
            
            .nav-right {
                margin-left: 0;
            }
        }
        
        @media (max-width: 480px) {
            .nav-container {
                padding: 0 8px;
            }
            
            .logo-text .logo-main {
                font-size: 1rem;
            }
            
            .logo-text .logo-sub {
                font-size: 0.7rem;
            }
        }
    </style>
</head>
<body>
    <!-- Pre-loader -->
    <div class="preloader" id="preloader">
        <div class="preloader-content">
            <div class="preloader-logo">
                <?php if (!empty($logoPath) && file_exists($logoPath)): ?>
                    <img src="<?php echo htmlspecialchars($logoPath); ?>" alt="<?php echo htmlspecialchars($siteName); ?>" class="preloader-logo-img">
                <?php endif; ?>
            </div>
            <div class="preloader-text"><?php echo htmlspecialchars($siteName); ?></div>
            <div class="preloader-subtitle">Loading your banking experience...</div>
            <div class="preloader-progress">
                <div class="preloader-progress-bar"></div>
            </div>
        </div>
    </div>

    <!-- Top Header Bar -->
    <div class="top-header">
        <div class="top-header-left">
            <div class="dropdown">
                <a href="#" class="top-link">
                    Looking Personal Banking <i class="fas fa-chevron-down"></i>
                </a>
                <div class="dropdown-content">
                    <a href="#">Savings Account</a>
                    <a href="#">Current Account</a>
                    <a href="#">Business Account</a>
                    <a href="#">Premium Account</a>
                </div>
            </div>
            <a href="#" class="top-link">
                <i class="fas fa-map-marker-alt"></i> Find Nearest Branch
            </a>
        </div>
        <div class="top-header-right">
            <a href="login.php" class="top-link">Login</a>
            <a href="register.php" class="top-link">Register</a>
            <a href="#" class="top-link">
                <i class="fas fa-search"></i> Search
            </a>
        </div>
    </div>

    <!-- Main Navigation Bar -->
    <nav class="main-nav">
        <div class="nav-container">
            <div class="nav-left">
                <div class="logo">
                    <?php if (!empty($logoPath) && file_exists($logoPath)): ?>
                        <div class="logo-image">
                            <img src="<?php echo htmlspecialchars($logoPath); ?>" alt="<?php echo htmlspecialchars($siteName); ?>" class="logo-img">
                        </div>
                    <?php else: ?>
                        <div class="logo-emblem">
                            <span class="logo-t">T</span>
                            <span class="logo-b">B</span>
                        </div>
                    <?php endif; ?>
                    <div class="logo-text">
                        <div class="logo-main"><?php echo htmlspecialchars($siteName); ?></div>
                        <div class="logo-sub">Credit</div>
                    </div>
                </div>
            </div>
            
            <div class="nav-center">
                <a href="#" class="nav-link active">Home</a>
                <div class="dropdown">
                    <a href="#" class="nav-link">
                        Services <i class="fas fa-chevron-down"></i>
                    </a>
                    <div class="dropdown-content">
                        <a href="#">Personal Banking</a>
                        <a href="#">Business Banking</a>
                        <a href="#">Loans & Credit</a>
                        <a href="#">Investment Services</a>
                    </div>
                </div>
                <div class="dropdown">
                    <a href="#" class="nav-link">
                        About <i class="fas fa-chevron-down"></i>
                    </a>
                    <div class="dropdown-content">
                        <a href="#">Our Story</a>
                        <a href="#">Leadership</a>
                        <a href="#">Careers</a>
                        <a href="#">News</a>
                    </div>
                </div>
                <div class="dropdown">
                    <a href="#" class="nav-link">
                        Apply Now <i class="fas fa-chevron-down"></i>
                    </a>
                    <div class="dropdown-content">
                        <a href="#">Open Account</a>
                        <a href="#">Apply for Loan</a>
                        <a href="#">Credit Card</a>
                        <a href="#">Investment</a>
                    </div>
                </div>
                <a href="#" class="nav-link">Get In Touch</a>
            </div>
            
            <div class="nav-right">
                <a href="login.php" class="btn btn-login">
                    <i class="fas fa-user"></i> Login
                </a>
                <a href="register.php" class="btn btn-primary">
                    <i class="fas fa-user-plus"></i> Register
                </a>
                
                <!-- Mobile Menu Toggle -->
                <button class="mobile-menu-toggle" id="mobileMenuToggle">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>
        
        <!-- Mobile Navigation -->
        <div class="mobile-nav" id="mobileNav">
            <a href="#" class="active">Home</a>
            <div class="dropdown">
                <a href="#" class="nav-link">
                    Services <i class="fas fa-chevron-down"></i>
                </a>
                <div class="dropdown-content">
                    <a href="#">Personal Banking</a>
                    <a href="#">Business Banking</a>
                    <a href="#">Loans & Credit</a>
                    <a href="#">Investment Services</a>
                </div>
            </div>
            <div class="dropdown">
                <a href="#" class="nav-link">
                    About <i class="fas fa-chevron-down"></i>
                </a>
                <div class="dropdown-content">
                    <a href="#">Our Story</a>
                    <a href="#">Leadership</a>
                    <a href="#">Careers</a>
                    <a href="#">News</a>
                </div>
            </div>
            <div class="dropdown">
                <a href="#" class="nav-link">
                    Apply Now <i class="fas fa-chevron-down"></i>
                </a>
                <div class="dropdown-content">
                    <a href="#">Open Account</a>
                    <a href="#">Apply for Loan</a>
                    <a href="#">Credit Card</a>
                    <a href="#">Investment</a>
                </div>
            </div>
            <a href="#">Get In Touch</a>
            <a href="login.php">Login</a>
            <a href="register.php">Open an Account</a>
        </div>
    </nav>

    <!-- Promotional Banner -->
    <div class="promo-banner">
        <div class="promo-content">
            <div class="promo-main">
                <strong>Updates:</strong> Enjoy up to 4%* interest on <?php echo htmlspecialchars($siteName); ?> Savings Accounts. Secure your future with us. 
                <a href="#" class="promo-link">> More Details</a>
            </div>
            <div class="promo-sub">
                Dear Customer, you can now open your <?php echo htmlspecialchars($siteName); ?> account with ease through our seamless Video KYC service.
            </div>
        </div>
    </div>

    <!-- Enhanced Hero Section with Parallax -->
    <section class="hero-enhanced parallax-container">
        <!-- Debug: Hero Image Path: <?php echo htmlspecialchars($heroImage); ?> -->
        <div class="parallax-bg" style="background-image: url('<?php echo htmlspecialchars($heroImage); ?>');" id="heroBg"></div>
        <div class="parallax-overlay"></div>
        
        <!-- Floating Elements -->
        <div class="floating-elements">
            <div class="floating-circle"></div>
            <div class="floating-circle"></div>
            <div class="floating-circle"></div>
        </div>
        
        <div class="hero-content-enhanced parallax-content">
            <h1 class="hero-title-enhanced animated-text">
                <?php echo htmlspecialchars($heroTitle); ?>
            </h1>
            <p class="hero-subtitle-enhanced animated-text delay-1">
                Join thousands of satisfied customers enjoying smart banking with <?php echo htmlspecialchars($siteName); ?>'s secure and innovative services.
            </p>
            <div class="hero-buttons animated-text delay-2">
                <a href="login.php" class="btn-hero-enhanced btn-hero-primary">
                    <i class="fas fa-sign-in-alt"></i> Login to Dashboard
                </a>
                <a href="register.php" class="btn-hero-enhanced btn-hero-secondary">
                    <i class="fas fa-user-plus"></i> Open Account
                </a>
            </div>
        </div>
    </section>

    <!-- Floating Sidebars -->
    <div class="floating-sidebar left">
        <button class="floating-btn">
            <i class="fas fa-play"></i>
            <span>Make Payment</span>
        </button>
        <button class="floating-btn">
            <i class="fas fa-play"></i>
            <span>Make an Enquiry</span>
        </button>
    </div>

    <div class="floating-sidebar right">
        <button class="floating-btn">
            <i class="fas fa-arrow-right"></i>
        </button>
    </div>
    
    <!-- Fixed Google Translator -->
    <div id="google_translate_element" class="translator-container"></div>

    <!-- Main Content Sections -->
    <section class="features">
        <div class="container">
            <h2 class="animated-text">Why Choose <?php echo htmlspecialchars($siteName); ?>?</h2>
            <div class="features-grid">
                <div class="feature-card animated-text delay-1">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3>Secure Banking</h3>
                    <p>Your money is protected with state-of-the-art security measures and encryption.</p>
                </div>
                <div class="feature-card animated-text delay-2">
                    <div class="feature-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <h3>Mobile Banking</h3>
                    <p>Bank anywhere, anytime with our award-winning mobile banking app.</p>
                </div>
                <div class="feature-card animated-text delay-3">
                    <div class="feature-icon">
                        <i class="fas fa-headset"></i>
                    </div>
                    <h3>24/7 Support</h3>
                    <p>Our customer service team is available round the clock to help you.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h4><?php echo htmlspecialchars($siteName); ?></h4>
                    <p>Building a brighter financial future for our customers with innovative banking solutions.</p>
                </div>
                <div class="footer-section">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="#">About Us</a></li>
                        <li><a href="#">Services</a></li>
                        <li><a href="#">Contact</a></li>
                        <li><a href="#">Support</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Contact Info</h4>
                    <p><i class="fas fa-phone"></i> <?php echo htmlspecialchars($phoneNumber); ?></p>
                    <p><i class="fas fa-envelope"></i> info@<?php echo strtolower(str_replace(' ', '', $siteName)); ?>.com</p>
                    <p><i class="fas fa-map-marker-alt"></i> <?php echo htmlspecialchars($address); ?></p>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2025 <?php echo htmlspecialchars($siteName); ?>. All rights reserved.</p>
                <div class="footer-links">
                    <a href="#">Privacy Policy</a>
                    <a href="#">Terms of Service</a>
                    <a href="#">Contact Support</a>
                </div>
            </div>
        </div>
    </footer>

    <!-- JavaScript -->
    <script src="assets/js/main.js"></script>
    
    <!-- Enhanced JavaScript for Pre-loader, Parallax, and Animations -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Pre-loader functionality
            const preloader = document.getElementById('preloader');
            
            // Hide preloader after page loads
            window.addEventListener('load', function() {
                setTimeout(() => {
                    preloader.classList.add('hidden');
                    // Remove preloader from DOM after animation
                    setTimeout(() => {
                        preloader.remove();
                    }, 500);
                }, 2000); // Show for 2 seconds minimum
            });
            
            // Mobile menu toggle
            const mobileMenuToggle = document.getElementById('mobileMenuToggle');
            const mobileNav = document.getElementById('mobileNav');
            
            mobileMenuToggle.addEventListener('click', function() {
                mobileNav.classList.toggle('active');
                const icon = this.querySelector('i');
                icon.classList.toggle('fa-bars');
                icon.classList.toggle('fa-times');
            });
            
            // Close mobile menu when clicking outside
            document.addEventListener('click', function(event) {
                if (!mobileMenuToggle.contains(event.target) && !mobileNav.contains(event.target)) {
                    mobileNav.classList.remove('active');
                    const icon = mobileMenuToggle.querySelector('i');
                    icon.classList.add('fa-bars');
                    icon.classList.remove('fa-times');
                }
            });
            
            // Parallax scrolling effect
            const heroBg = document.getElementById('heroBg');
            
            // Debug: Check if hero image is loading
            if (heroBg) {
                const bgImage = new Image();
                bgImage.onload = function() {
                    console.log('Hero image loaded successfully');
                };
                bgImage.onerror = function() {
                    console.log('Hero image failed to load');
                    // Fallback to gradient background
                    heroBg.style.background = 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)';
                };
                const bgUrl = heroBg.style.backgroundImage.replace(/url\(['"]?([^'"]*)['"]?\)/, '$1');
                bgImage.src = bgUrl;
            }
            
            window.addEventListener('scroll', function() {
                const scrolled = window.pageYOffset;
                const rate = scrolled * -0.5;
                
                if (heroBg) {
                    heroBg.style.transform = `translateY(${rate}px)`;
                }
            });
            
            // Intersection Observer for animations
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };
            
            const observer = new IntersectionObserver(function(entries) {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.animationPlayState = 'running';
                    }
                });
            }, observerOptions);
            
            // Observe all animated elements
            document.querySelectorAll('.animated-text').forEach(el => {
                el.style.animationPlayState = 'paused';
                observer.observe(el);
            });
            
            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function (e) {
                    e.preventDefault();
                    const target = document.querySelector(this.getAttribute('href'));
                    if (target) {
                        target.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });
            
            // Add scroll effect to navigation
            let lastScrollTop = 0;
            const mainNav = document.querySelector('.main-nav');
            
            window.addEventListener('scroll', function() {
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                if (scrollTop > 100) {
                    mainNav.style.background = 'rgba(102, 126, 234, 0.95)';
                    mainNav.style.backdropFilter = 'blur(10px)';
                } else {
                    mainNav.style.background = '';
                    mainNav.style.backdropFilter = '';
                }
                
                lastScrollTop = scrollTop;
            });
        });
    </script>
</body>
</html>