<?php
session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'customer') {
    header('Location: login.php');
    exit();
}

// Check if transfer success session exists
if (!isset($_SESSION['transfer_success'])) {
    header('Location: transfer.php');
    exit();
}

require_once 'admin/config/database.php';

// Format currency display
function formatCurrency($amount, $currencySymbol) {
    return $currencySymbol . number_format($amount, 2);
}

$database = new Database();
$conn = $database->getConnection();

// Get user data
$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

$database->closeConnection();

// Get transfer details from session before clearing
$transfer_reference = $_SESSION['transfer_reference'] ?? '';
$transfer_amount = $_SESSION['transfer_amount'] ?? 0;
$transfer_beneficiary = $_SESSION['transfer_beneficiary'] ?? '';

// Clear success session
unset($_SESSION['transfer_success']);
unset($_SESSION['transfer_reference']);
unset($_SESSION['transfer_amount']);
unset($_SESSION['transfer_beneficiary']);

// Get current date and time
$current_date = date('l, F j, Y');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transfer Successful - TrustBeam Credit</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .success-container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }

        .success-card {
            background: white;
            border-radius: 15px;
            padding: 40px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border: 1px solid #e0e6ed;
            text-align: center;
        }

        .success-icon {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            color: white;
            font-size: 3rem;
            animation: bounce 2s infinite;
        }

        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% {
                transform: translateY(0);
            }
            40% {
                transform: translateY(-10px);
            }
            60% {
                transform: translateY(-5px);
            }
        }

        .success-title {
            color: #28a745;
            margin: 0 0 15px 0;
            font-size: 2rem;
            font-weight: 700;
        }

        .success-subtitle {
            color: #6c757d;
            margin: 0 0 30px 0;
            font-size: 1.1rem;
        }

        .transfer-summary {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 25px;
            margin-bottom: 30px;
            text-align: left;
        }

        .summary-title {
            color: #2c3e50;
            margin: 0 0 20px 0;
            font-size: 1.2rem;
            font-weight: 600;
            text-align: center;
        }

        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #e9ecef;
        }

        .summary-row:last-child {
            margin-bottom: 0;
            border-bottom: none;
            padding-bottom: 0;
        }

        .summary-label {
            color: #6c757d;
            font-weight: 500;
        }

        .summary-value {
            color: #2c3e50;
            font-weight: 600;
        }

        .summary-value.amount {
            color: #dc3545;
            font-size: 1.1rem;
        }

        .success-actions {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 15px 30px;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.3s ease;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: #6c757d;
            color: white;
            border: none;
            padding: 15px 30px;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s ease;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn-secondary:hover {
            background: #5a6268;
        }

        .status-badge {
            display: inline-block;
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.9rem;
            margin-bottom: 20px;
        }

        .status-completed {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        /* Print Receipt Styles */
        @media print {
            body * {
                visibility: hidden;
            }
            
            .receipt-container, .receipt-container * {
                visibility: visible;
            }
            
            .receipt-container {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                background: white;
                padding: 20px;
            }
            
            .no-print {
                display: none !important;
            }
        }

        .receipt-container {
            display: none;
            max-width: 400px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border: 2px solid #e0e6ed;
            border-radius: 10px;
            font-family: 'Arial', sans-serif;
        }

        .receipt-header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #667eea;
            padding-bottom: 20px;
        }

        .receipt-logo {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 15px;
        }

        .receipt-logo .logo-emblem {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            color: white;
            font-weight: bold;
            font-size: 1.2rem;
        }

        .receipt-logo .logo-text {
            text-align: left;
        }

        .receipt-logo .logo-main {
            font-size: 1.5rem;
            font-weight: 700;
            color: #2c3e50;
            margin: 0;
        }

        .receipt-logo .logo-sub {
            font-size: 0.9rem;
            color: #667eea;
            margin: 0;
        }

        .receipt-title {
            font-size: 1.8rem;
            font-weight: 700;
            color: #28a745;
            margin: 0 0 10px 0;
        }

        .receipt-subtitle {
            font-size: 1rem;
            color: #6c757d;
            margin: 0;
        }

        .receipt-details {
            margin-bottom: 25px;
        }

        .receipt-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 12px;
            padding: 8px 0;
            border-bottom: 1px dotted #e0e6ed;
        }

        .receipt-row:last-child {
            border-bottom: none;
        }

        .receipt-label {
            font-weight: 600;
            color: #2c3e50;
        }

        .receipt-value {
            font-weight: 500;
            color: #495057;
            text-align: right;
        }

        .receipt-value.amount {
            font-size: 1.1rem;
            font-weight: 700;
            color: #dc3545;
        }

        .receipt-footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #667eea;
        }

        .receipt-thankyou {
            font-size: 1rem;
            color: #28a745;
            font-weight: 600;
            margin-bottom: 10px;
        }

        .receipt-contact {
            font-size: 0.85rem;
            color: #6c757d;
            margin: 5px 0;
        }

        .receipt-date {
            font-size: 0.8rem;
            color: #6c757d;
            margin-top: 15px;
        }

        /* Mobile responsive */
        @media (max-width: 768px) {
            .success-container {
                padding: 10px;
            }
            
            .success-card {
                padding: 30px 20px;
            }
            
            .success-actions {
                flex-direction: column;
                align-items: stretch;
            }
        }
    </style>
</head>
<body class="dashboard-page">
    <!-- Top Header Bar -->
    <div class="dashboard-header">
        <div class="header-left">
            <div class="current-balance">
                <span class="balance-label">Current Balance</span>
                <span class="balance-amount"><?php echo formatCurrency($user['balance'], $_SESSION['currency'] ?? '$'); ?></span>
            </div>
        </div>
        <div class="header-center">
            <div class="current-date"><?php echo $current_date; ?></div>
        </div>
        <div class="header-right">
            <div class="header-actions">
                <button class="notification-btn">
                    <i class="fas fa-bell"></i>
                    <span class="notification-badge">3</span>
                </button>
                <div class="user-profile">
                    <div class="user-avatar">
                        <?php if ($user['profile_photo']): ?>
                            <img src="admin/<?php echo htmlspecialchars($user['profile_photo']); ?>" alt="Profile Photo">
                        <?php else: ?>
                            <span><?php echo strtoupper(substr($user['firstname'], 0, 1) . substr($user['lastname'], 0, 1)); ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="user-info">
                        <span class="user-name"><?php echo htmlspecialchars($user['firstname'] . ' ' . $user['lastname']); ?></span>
                        <span class="user-id"><?php echo htmlspecialchars($user['account_number']); ?></span>
                        <span class="kyc-badge">KYC Verified</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="dashboard-container">
        <!-- Mobile Menu Toggle -->
        <button class="mobile-menu-toggle" id="mobileMenuToggle">
            <i class="fas fa-bars"></i>
        </button>
        
        <!-- Sidebar Overlay -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>
        
        <!-- Sidebar -->
        <aside class="dashboard-sidebar">
            <div class="sidebar-header">
                <div class="logo">
                    <div class="logo-emblem">
                        <span class="logo-t">T</span>
                        <span class="logo-b">B</span>
                    </div>
                    <div class="logo-text">
                        <div class="logo-main">TrustBeam</div>
                        <div class="logo-sub">Credit</div>
                    </div>
                </div>
            </div>
            
            <div class="user-profile-sidebar">
                <div class="user-avatar-sidebar">
                    <?php if ($user['profile_photo']): ?>
                        <img src="admin/<?php echo htmlspecialchars($user['profile_photo']); ?>" alt="Profile Photo">
                    <?php else: ?>
                        <span><?php echo strtoupper(substr($user['firstname'], 0, 1) . substr($user['lastname'], 0, 1)); ?></span>
                    <?php endif; ?>
                </div>
                <div class="user-details">
                    <div class="user-name"><?php echo htmlspecialchars($user['firstname'] . ' ' . $user['lastname']); ?></div>
                    <div class="user-id"><?php echo htmlspecialchars($user['account_number']); ?></div>
                    <span class="kyc-badge">KYC Verified</span>
                </div>
                <div class="profile-actions">
                    <a href="profile.php" class="btn-profile">
                        <i class="fas fa-user"></i> Profile
                    </a>
                    <a href="logout.php" class="btn-logout">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                </div>
            </div>
            
            <nav class="sidebar-nav">
                <div class="nav-section">
                    <h3>Main Menu</h3>
                    <ul>
                        <li><a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a></li>
                        <li><a href="transactions.php"><i class="fas fa-exchange-alt"></i> Transactions</a></li>
                        <li><a href="transfer.php" class="active"><i class="fas fa-paper-plane"></i> Transfer Funds</a></li>
                        <li><a href="cards.php"><i class="fas fa-credit-card"></i> Cards</a></li>
                    </ul>
                </div>
                
                <div class="nav-section">
                    <h3>Services</h3>
                    <ul>
                        <li><a href="loan-request.php"><i class="fas fa-hand-holding-usd"></i> Loan Request</a></li>
                        <li><a href="loan-history.php"><i class="fas fa-history"></i> Loan History</a></li>
                        <li><a href="irs-refund.php"><i class="fas fa-file-invoice-dollar"></i> IRS Refund</a></li>
                        <li><a href="apply-card.php"><i class="fas fa-id-card"></i> Apply for Card</a></li>
                    </ul>
                </div>
            </nav>
            
            <div class="sidebar-footer">
                <div class="support-info">
                    <h4>Need Help?</h4>
                    <p>Contact our 24/7 support team</p>
                    <a href="mailto:support@trustbeamcredit.com" class="support-link">
                        <i class="fas fa-envelope"></i> support@trustbeamcredit.com
                    </a>
                </div>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="dashboard-main">
            <div class="success-container">
                <div class="success-card">
                    <div class="success-icon">
                        <i class="fas fa-check"></i>
                    </div>

                    <h1 class="success-title">Transfer Successful!</h1>
                    <p class="success-subtitle">Your transfer has been completed successfully</p>

                    <div class="status-badge status-completed">
                        <i class="fas fa-check-circle"></i> Completed
                    </div>

                    <!-- Transfer Summary -->
                    <div class="transfer-summary">
                        <h3 class="summary-title">Transfer Summary</h3>
                        <div class="summary-row">
                            <span class="summary-label">Transfer Amount:</span>
                            <span class="summary-value amount">-<?php echo formatCurrency($transfer_amount, $_SESSION['currency'] ?? '$'); ?></span>
                        </div>
                        <div class="summary-row">
                            <span class="summary-label">Beneficiary:</span>
                            <span class="summary-value"><?php echo htmlspecialchars($transfer_beneficiary); ?></span>
                        </div>
                        <div class="summary-row">
                            <span class="summary-label">Reference Number:</span>
                            <span class="summary-value"><?php echo htmlspecialchars($transfer_reference); ?></span>
                        </div>
                        <div class="summary-row">
                            <span class="summary-label">Date & Time:</span>
                            <span class="summary-value"><?php echo date('M d, Y H:i A'); ?></span>
                        </div>
                        <div class="summary-row">
                            <span class="summary-label">Status:</span>
                            <span class="summary-value" style="color: #28a745;">Completed</span>
                        </div>
                    </div>

                    <div class="success-actions">
                        <button onclick="printReceipt()" class="btn-primary">
                            <i class="fas fa-print"></i> Print Receipt
                        </button>
                        <a href="transactions.php" class="btn-secondary">
                            <i class="fas fa-list"></i> View Transactions
                        </a>
                        <a href="transfer.php" class="btn-secondary">
                            <i class="fas fa-paper-plane"></i> New Transfer
                        </a>
                        <a href="dashboard.php" class="btn-secondary">
                            <i class="fas fa-home"></i> Dashboard
                        </a>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Print Receipt (Hidden by default) -->
    <div class="receipt-container" id="receiptContainer">
        <div class="receipt-header">
            <div class="receipt-logo">
                <div class="logo-emblem">
                    <span>T</span>
                    <span>B</span>
                </div>
                <div class="logo-text">
                    <div class="logo-main">TrustBeam</div>
                    <div class="logo-sub">Credit</div>
                </div>
            </div>
            <h1 class="receipt-title">TRANSFER RECEIPT</h1>
            <p class="receipt-subtitle">Transaction Completed Successfully</p>
        </div>

        <div class="receipt-details">
            <div class="receipt-row">
                <span class="receipt-label">Transfer Amount:</span>
                <span class="receipt-value amount">-<?php echo formatCurrency($transfer_amount, $_SESSION['currency'] ?? '$'); ?></span>
            </div>
            <div class="receipt-row">
                <span class="receipt-label">Beneficiary:</span>
                <span class="receipt-value"><?php echo htmlspecialchars($transfer_beneficiary); ?></span>
            </div>
            <div class="receipt-row">
                <span class="receipt-label">Account Holder:</span>
                <span class="receipt-value"><?php echo htmlspecialchars($user['firstname'] . ' ' . $user['lastname']); ?></span>
            </div>
            <div class="receipt-row">
                <span class="receipt-label">Account Number:</span>
                <span class="receipt-value"><?php echo htmlspecialchars($user['account_number']); ?></span>
            </div>
            <div class="receipt-row">
                <span class="receipt-label">Reference Number:</span>
                <span class="receipt-value"><?php echo htmlspecialchars($transfer_reference); ?></span>
            </div>
            <div class="receipt-row">
                <span class="receipt-label">Transaction Date:</span>
                <span class="receipt-value"><?php echo date('M d, Y'); ?></span>
            </div>
            <div class="receipt-row">
                <span class="receipt-label">Transaction Time:</span>
                <span class="receipt-value"><?php echo date('H:i A'); ?></span>
            </div>
            <div class="receipt-row">
                <span class="receipt-label">Status:</span>
                <span class="receipt-value" style="color: #28a745;">Completed</span>
            </div>
        </div>

        <div class="receipt-footer">
            <div class="receipt-thankyou">Thank you for banking with us!</div>
            <div class="receipt-contact">For support, contact us at:</div>
            <div class="receipt-contact">support@trustbeamcredit.com</div>
            <div class="receipt-contact">+1 (555) 123-4567</div>
            <div class="receipt-date">Generated on <?php echo date('M d, Y H:i A'); ?></div>
        </div>
    </div>

    <script>
        // Mobile menu toggle
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuToggle = document.getElementById('mobileMenuToggle');
            const sidebar = document.querySelector('.dashboard-sidebar');
            const overlay = document.getElementById('sidebarOverlay');

            mobileMenuToggle.addEventListener('click', function() {
                sidebar.classList.toggle('active');
                overlay.classList.toggle('active');
            });

            overlay.addEventListener('click', function() {
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
            });
        });

        // Print Receipt Function
        function printReceipt() {
            const receiptContainer = document.getElementById('receiptContainer');
            
            // Show the receipt container temporarily
            receiptContainer.style.display = 'block';
            
            // Print the receipt
            window.print();
            
            // Hide the receipt container after printing
            setTimeout(() => {
                receiptContainer.style.display = 'none';
            }, 1000);
        }
    </script>
    <script src="assets/js/logout-confirmation.js"></script>
</body>
</html>
